package spring.boot;

import lombok.Data;
import org.hibernate.validator.constraints.CreditCardNumber;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * @Created 09 / 03 / 2020 - 11:14 AM
 * @project SpringAction
 * @Author Hamdamboy
 */

@Data
public class Order {
    //
    //end::allButValidation[]
    @NotBlank(message = "Name is required")
    //tag::allButValidation[]
    private String name;
    //end::allButValidation
    @NotBlank(message = "Street is required")
    //tag::allButValidation[]
    private String street;
    //end::allButValidation[]

    @NotBlank(message = "City is required")
    //tag::allButValidation[]
    private String city;
    //end::allButValidation[]

    @NotBlank(message = "State is required")
    //tag::allButValidation[]
    private String state;

    @NotBlank(message = "Zip code is required")
    //tag::allButValidation[]
    private String zip;
    //end::allButValidation[]

    @CreditCardNumber(message = "Not a valid credit card number")
    //tag::allButValidation[]
    private String ccNumber;
    //end::allButValidation[]

    @Pattern(regexp = "^(0[1-9]|1[0-2])([\\\\/])([1-9][0-9])$", message = "Must be formatted MM/YY")
    //tag::allButValidation[]
    private String ccExpiration;
    //end::allButValidation[]

    @Digits(integer = 3, fraction = 0, message = "Invalid CVV")
    //tag::allButValidation[]
    private String ccCVV;


}

//end::allButValidation[]
//end::all[]